# Parts List: Terracore Alpha Stationary Appliance Prototype

Concept: A countertop-sized, wall-powered unit that demonstrates the core food synthesis process (hermetic thermal core, deposition, mycelium growth). Think of it as a bio-printer in a box.

Total Estimated Cost: $750 - $1,400 AUD

## 1. Enclosure & Structure
- Main Chassis: Pre-fabricated project box or small insulated cooler
- Internal Framing: 3D-printed mounts and brackets
- Viewing Window: Clear acrylic or polycarbonate sheet
- Sealing: Food-grade silicone gaskets and sealant
- Estimated Cost: $80 - $150

## 2. Thermal Core Subsystem
- Heating Element: Cartridge heaters or flexible silicone heater pad
- Temperature Sensor: High-precision digital sensor
- Thermal Mass: Aluminum plate or block for even heat distribution
- Insulation: Ceramic wool or foam insulation panels
- Controller: PID temperature controller
- Estimated Cost: $100 - $220

## 3. Deposition & Nutrient Delivery
- Motion System: Small 2-axis or 3-axis gantry kit
- Deposition Nozzle: Syringe needle or custom printed nozzle
- Material Pump: Peristaltic pump or digitally-controlled syringe pump
- Reservoir: Food-grade container for nutrient slurry
- Estimated Cost: $150 - $300

## 4. Bio-Chamber & Environmental Control
- Internal Tray: Sterilizable, removable tray
- Humidity Sensor: DHT22 or similar
- Humidifier: Mini ultrasonic fogger/mister
- Air Exchange: Small 5V PC fans
- Air Filter: HEPA filter patch
- LED Grow Light: Small full-spectrum LED strip
- Estimated Cost: $80 - $180

## 5. Control & Electronics
- Main Controller: Arduino Mega or ESP32
- Motor Drivers: Stepper motor drivers
- Power Supply: 12V DC regulated wall plug
- Relay Module: For switching heater and humidifier
- Wiring & Connectors: Spool of wire, connectors
- Estimated Cost: $120 - $250

## 6. Biological Components
- Mycelium Culture: Oyster mushroom liquid culture
- Substrate: Sterilized sawdust blocks
- Nutrient Base: Materials for nutrient slurry
- Estimated Cost: $40 - $80

## 7. Tools & Consumables
- Soldering Iron, Solder, Basic Hand Tools
- 3D Printer Filament
- Isopropyl Alcohol for sterilization
- Estimated Cost: $80 - $120

## Implementation Notes
This stationary prototype demonstrates the core technology without the complexity of mobility or off-grid power. The wall-power design focuses resources on perfecting the thermal regulation and deposition systems that form the proprietary Terracore technology platform.

This appliance model serves as a practical development platform and convincing demonstration unit for potential partners and investors.
